#pragma once
#include "Goomba.h"
#include "Koopa.h"
#include "Mario.h"
#include "ItemManager.h"

//EnemyManager handles all logic of creating, spawning, despawning and rendering of all game enemies in the level

class EnemyManager
{
public:
	EnemyManager();
	~EnemyManager();

	void create(MySprite::SpriteType enemyType, sf::Vector2f spawn);	//Create a new enemy of enemyType to spawn in at spawn
	void checkSpawn(Mario* mario);	//Check if the enemy should spawn in if it is close to mario
	void update(float dt, Mario* mario, ItemManager* itemManager);
	void deathCheck(Mario* mario);	//Check if we should kill the enemy if it is too far from mario
	void render(sf::RenderWindow* window);

private:
	struct SpawnStruct	//Create a SpawnStruct to store every typeOfEnemy, their spawnLocation and if they have been spawned
	{
		MySprite::SpriteType typeOfEnemy;
		sf::Vector2f spawnLocation;
		bool isSpawned;
	};

	std::vector<Enemy*> enemies;	//enemies vector stores all the current enemies on the screen
	std::vector<SpawnStruct*> enemySpawns;	//enemySpawns vector stores all the spawn locations of all enemies
	sf::Texture enemyTexture;

};

